/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.CEADescriptor;
import com.quantumdata.edideditor.CEASVD;
import com.quantumdata.edideditor.DataBlock;
import com.quantumdata.edideditor.DescriptorType;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEAVideoDataBlock
extends DataBlock {
    private ArrayList<CEASVD> aSVDs = new ArrayList();
    public static final int maxNumDescriptors = 31;
    private static final int descriptorSize = 1;
    private static final int iVideoTagCode = 2;

    public CEAVideoDataBlock() {
        super(1);
        this.iDataBlockTagCode = 2;
    }

    @Override
    public void removeDescriptor(int n) {
        this.aSVDs.remove(n);
        this.adjustNumDescriptors(-1);
    }

    @Override
    public void removeAllDescriptors() {
        this.aSVDs.clear();
        this.adjustNumDescriptors(0);
    }

    @Override
    public String getDataBlockName() {
        return DescriptorType.SHORT_VIDEO_DES.getBlockName();
    }

    @Override
    public boolean addDescriptor(CEADescriptor cEADescriptor) {
        boolean bl = false;
        CEASVD cEASVD = (CEASVD)cEADescriptor;
        if (this.aSVDs == null) {
            this.aSVDs = new ArrayList();
        }
        if (this.aSVDs.size() == this.iMaxNumberDescriptors) {
            bl = false;
        } else {
            this.aSVDs.add(cEASVD);
            this.adjustNumDescriptors(1);
            bl = true;
        }
        return bl;
    }

    public ArrayList<CEASVD> getDescriptors() {
        return this.aSVDs;
    }

    public void clearDescriptors() {
        this.aSVDs.clear();
        this.aSVDs = null;
        this.adjustNumDescriptors(0);
    }

    @Override
    public String uploadDataBlockData(String string) {
        String string2 = null;
        super.setHeader(string.substring(0, 2));
        int n = 0;
        int n2 = 2;
        if (this.getCurrentNumDescriptors() != (string.length() - 2) / 2) {
            string2 = "ERROR: Descriptor length doesn't match length of descriptors";
            return string2;
        }
        while (n < this.getCurrentNumDescriptors()) {
            CEASVD cEASVD = new CEASVD();
            cEASVD.uploadDescriptorData(string.substring(n2, n2 + 2));
            this.aSVDs.add(cEASVD);
            ++n;
            n2 += 2;
        }
        if (string.length() - n2 > 0) {
            string2 = "ERROR: Problem uploading Video Data Block Data provided for data block exceeds capacity of data block";
            return string2;
        }
        return string2;
    }

    @Override
    public String extractDataBlockData() {
        String string = new String();
        string = string.concat(super.getHeader());
        for (int i = 0; i < this.getCurrentNumDescriptors(); ++i) {
            string = string.concat(this.aSVDs.get(i).extractDescriptorData());
        }
        return string;
    }

    @Override
    public int getDataBlockChecksum() {
        String string = this.extractDataBlockData();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            n2 += Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return n2 & 0xFF;
    }
}

